#ifndef __CDLLLoader__
#define __CDLLLoader__

#include "../Basics/CString.hpp"
using Exponent::Basics::CString;

//	===========================================================================

namespace Exponent
{
	namespace Host
	{
		/**
		 * @class CDLLLoader CDLLLoader.hpp
		 * @brief Loads a Dll and provides access to functions
		 *
		 * @date 25/09/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 * @version 1.0.1 Removed virtual calls
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CDLLLoader.hpp,v 1.6 2007/02/08 21:06:44 paul Exp $
		 */
		class CDLLLoader : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 */
			CDLLLoader();

			/**
			 * Construction
			 * @param dllName Path to the DLL
			 * @throws CException
			 */
			CDLLLoader(const CString &dllName);

			/**
			 * Destruction
			 */
			virtual ~CDLLLoader();

//	===========================================================================

			/**
			 * Load a module
			 * @param dllName Path to the DLL
			 * @throws CException
			 */
			void loadDLL(const CString &dllName);

			/**
			 * Unload a module
			 */
			void unloadDLL();

//	===========================================================================

			/**
			 * Get a function
			 * @param functionName The name of the function to load
			 * @retval void* A pointer to the function
			 */
			void *getFunction(const CString &functionName);

//	===========================================================================

			/** @cond */
			#ifdef WIN32
			/** @endcond */
				/**
				 * Get the module handle
				 * @retval HMODULE The DLL Handle
				 */
				HMODULE getDllHandle() const { return m_dllHandle; }
			/** @cond */
			#else
			/** @endcond */
				/**
				 * Get the module handle
				 * @retval CFBundleRef The DLL Handle
				 */
				CFBundleRef getDllHandle() const { return m_dllHandle; }
			/** @cond */
			#endif
			/** @endcond */

//	===========================================================================

		protected:

//	===========================================================================

			CString m_dllName;				/**< Name of current DLL */
			/** @cond */
			#ifdef WIN32
			/** @endcond */
				HMODULE m_dllHandle;		/**< Handle to the dll */
			/** @cond */
			#else
			/** @endcond */
				CFBundleRef m_dllHandle;	/**< The bundle reference; */
			/** @cond */
			#endif
			/** @endcond */
		};
	}
}
#endif	// End of CDLLLoader.hpp